#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/poll.h>
#include "dbs.h"

static unsigned char InProgressFlag;		// Making connection to server
static unsigned char ConnectedFlag;		// Connected to server
static unsigned char QueueEmptyFlag=1;		// Messages queue is empty
static unsigned long Sended=0;			/* Number if messages sended but 
			acknowlengement about reception didn't arive yet */
static int dsock;
static unsigned long QueueSize=0;
static unsigned long WaitResponse=0;

static struct pollfd pfd;
static struct pollfd fat;
void CheckProgress()
{
    int err;
    int errsize=sizeof(int);

    err=poll(&pfd,1,0);
    if (err>0)  
    {
	InProgressFlag=0;
	if ((pfd.revents&POLLERR)&&(pfd.revents&POLLHUP));
	else if (pfd.revents&POLLOUT)
	{
	    if (getsockopt(dsock,SOL_SOCKET,SO_ERROR,&err,&errsize))
	    {
		fprintf(stderr,"Can't read socket options\n");
		exit(1);
	    }
	    if (!err) ConnectedFlag=1;
	}
    }
}

void BrokenPipe()
{
    fprintf(stderr,"Connection to server lost!\n");
    ConnectedFlag=0;
    InProgressFlag=0;
}

static struct Queue *FirstItem=NULL, *LastItem=NULL;

void RemoveFromQueue(unsigned long n)
{
    struct Queue *qtmp;
    while ((FirstItem)&&(n>0))
    {
	free(FirstItem->buf);
	qtmp=FirstItem;
	FirstItem=FirstItem->Next;
	free(qtmp);
	n--; QueueSize--;
    }
    if (!FirstItem) {
	QueueEmptyFlag=1;
	LastItem=NULL;
    }
}

void DropQueue()
{
    FILE *f;
    char fname[80];
    struct Queue *qtmp;
    
    sprintf(fname,"%s/unsended.%lx",WritePath,time(NULL));
    f=fopen(fname,"w");
    if (!f)
	fprintf(stderr,"Can't open dump file. Missed data can be recovered from *.dat files\n");

    while (FirstItem)
    {
	if (f)
	{
	    fwrite(&(FirstItem->bufsize),1,1,f);
	    fwrite(FirstItem->buf,1,FirstItem->bufsize,f);
	}
	free(FirstItem->buf);
	qtmp=FirstItem;
	FirstItem=FirstItem->Next;
	free(qtmp);
    }
    if (f) fclose(f);
    LastItem=NULL;
    QueueEmptyFlag=1;
    QueueSize=0;
}

unsigned long int CalcUTMP(unsigned long int *utmpb, int n)
{
    int i;
    unsigned long int utmp=0;
    
    for (i=0;i<n;i++) utmp+=utmpb[i];
    return utmp;
}

void UpdateQueue()
{
    unsigned long utmp,utmpb[32];
    int err;
    
    err=recv(dsock,&utmpb,32*sizeof(unsigned long int),0);
    if (err>0) 
    {
	WaitResponse=0;
        utmp=CalcUTMP(utmpb,err/4);
        RemoveFromQueue(utmp);
	Sended-=utmp;
    }
}

static struct sockaddr_in servaddr;
extern int errno;
void dbsInitialise()
{
    int err;
    
    signal(SIGPIPE,BrokenPipe);

    dsock=socket(PF_INET,SOCK_STREAM,IPPROTO_TCP);
    if (dsock<0)
    {
	fprintf(stderr,"Can't open stream socket!\n");
	exit(1);
    }
    
    pfd.fd=dsock;
    pfd.events=0xFFFF;

    fat.fd=dsock;
    fat.events=POLLIN;
    
    	// Making socket NON_BLOCK
    fcntl(dsock,F_SETFL,O_NONBLOCK);
  
    servaddr.sin_family=AF_INET;
    servaddr.sin_port=htons(servport);
    servaddr.sin_addr.s_addr=inet_addr(server);

    err=connect(dsock,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in));
    if (err) 
    {
	ConnectedFlag=0;
	if (errno!=EINPROGRESS) 
	{
	    InProgressFlag=0;
	    fprintf(stderr,"Can't connect to server!\n");
	}
	else 
	    InProgressFlag=1;
    }
    else ConnectedFlag=1;
}


void dbsRelease()
{
    shutdown(dsock,1);	// Dissable outgoing traffic
    UpdateQueue();	// Removing last items from queue
    
    if (!QueueEmptyFlag) DropQueue();
    ConnectedFlag=0;
    InProgressFlag=0;
    close(dsock);
}


void Reconnect()
{
    int err;
    shutdown(dsock,2);	// Dissable outgoing traffic
    close(dsock);
    WaitResponse=0;
    Sended=0;
    dsock=socket(PF_INET,SOCK_STREAM,IPPROTO_TCP);
    if (dsock<0)
    {
	fprintf(stderr,"Can't open stream socket!\n");
	exit(1);
    }
    	// Making socket NON_BLOCK
    fcntl(dsock,F_SETFL,O_NONBLOCK);
    
    err=connect(dsock,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in));
    if (err) 
    {
        if (errno==EINPROGRESS) InProgressFlag=1;
    }
    else ConnectedFlag=1;
}

#define FastAckTimeout 1	  /* in milliseconds */
#define WaitResponseTimeout 5	  /* in cycles */

void dbsSend(void *buf, unsigned long bufsize)
{
    int err;
    unsigned long utmp,utmpb[32];

	// Trying recconect if connection lost
    if  (InProgressFlag) CheckProgress();

	// Check for network problems ( Server exited after net problems )
    if (Sended) WaitResponse++;
    if (WaitResponse>WaitResponseTimeout) Reconnect();

	// If till now not connected - reconecting
    if ((!ConnectedFlag)/*&&(!InProgressFlag)*/) Reconnect();
	// Sending message
    if ((ConnectedFlag)&&(QueueEmptyFlag))
    {
	UpdateQueue();
	err=send(dsock,buf,bufsize,MSG_DONTWAIT);
	printf("%li\n",err);
	if (err==bufsize) 
	{
	    if (poll(&fat,1,FastAckTimeout))
	    {
		err=recv(dsock,&utmpb,32*sizeof(unsigned long int),0);
    		if (err>0) 
		{
		    utmp=CalcUTMP(utmpb,err/4);
		    if (utmp>1) RemoveFromQueue(utmp-1);
		    WaitResponse=0;
		    return;
		}
	    }
	    Sended++;
	}
	else
	    fprintf(stderr,"Send failed. Staying new message in queue!\n");
    }
    else if (ConnectedFlag)
        fprintf(stderr, "Messages in queue remaining. Staying new message in queue!\n");
    else if (InProgressFlag)
	fprintf(stderr, "Connecting to server. Staying new message in queue!\n");
    else
	fprintf(stderr,"Can't connect to server. Staying new message in queue!\n");
    
    if (LastItem) 
    {
        LastItem->Next=(struct Queue*)malloc(sizeof(struct Queue));
        LastItem=LastItem->Next;
    }
    else
    {
        FirstItem=(struct Queue*)malloc(sizeof(struct Queue));
        LastItem=FirstItem;
        QueueEmptyFlag=0;
    }
    if (!LastItem) /*DS*/;
    LastItem->Next=NULL;
    LastItem->bufsize=bufsize;
    LastItem->buf=(void*)malloc(bufsize);
    if (!LastItem->buf) /*DS*/;
    memcpy(LastItem->buf,buf,bufsize);
    if ((++QueueSize)>MaxQueueSize) DropQueue();
}

void dbsProcess()
{
    int err;
    struct Queue *qtmp;
    
    if  (InProgressFlag) CheckProgress();
    if ((!ConnectedFlag)&&(!InProgressFlag)) Reconnect();
    
    if (ConnectedFlag) UpdateQueue();
    
    if ((ConnectedFlag)&&(!QueueEmptyFlag))
    {
	if (!Sended) 
	{
	    err=send(dsock,FirstItem->buf,FirstItem->bufsize,MSG_DONTWAIT);
	    Sended++;
	}
/*	if (err==FirstItem->bufsize) 
	{
	    QueueSize--;
	    qtmp=FirstItem;
	    FirstItem=FirstItem->Next;
	    free(qtmp->buf);
	    free(qtmp);
	    if (FirstItem==NULL)
	    {
		LastItem=NULL;
		QueueEmptyFlag=1;
	    }
	}*/
    }
}

