#define ppd 0x378		/* Paralell Port Data Register*/
unsigned short int pps=ppd+1;	// Paralell Port Status Register
unsigned short int ppc=ppd+2;	// Paralell Port Command Register

void InitialisePorts()
{
	// Getting permissions on required ports
    ioperm(ppd,3,1);
}

void WrTim(unsigned char tn, unsigned char sa, unsigned char data)
{
	  if (tn < 10) outb(0x80 + 4*tn + sa,ppd);
	  else outb(0x40 + 4*(tn - 10) + sa,ppd);
	  outb(2,ppc);   Pause(1);        /* PreWrAddress */
          outb(3,ppc);   Pause(1);        /* WrAddress Strobe */
          outb(2,ppc);   Pause(1);        /* Reset Strobe */
          outb(data,ppd);                 /* Data for Timer */
          outb(0,ppc);   Pause(1);        /* PreWrTimers */
          outb(1,ppc);   Pause(1);        /* WrTimers Strobe */
          outb(0,ppc);   Pause(1);        /* Reset Strobe */
          outb(0xC0,ppd);Pause(1);        /* End CS */
          outb(2,ppc);   Pause(1);        /* PreWrAddress */
          outb(3,ppc);   Pause(1);        /* WrAddress Strobe */
          outb(2,ppc);   Pause(1);        /* Reset Strobe */
}

unsigned char RdTim(unsigned char tn, unsigned char sa)
{
    unsigned char dl,dh;
    if (tn < 10) outb(0x80 + 4*tn + sa,ppd);
    else outb(0x40 + 4*(tn - 10) + sa,ppd);

	  outb(2,ppc);   Pause(1);        /* PreWrAddress */
          outb(3,ppc);   Pause(1);        /* WrAddress Strobe */
          outb(2,ppc);   Pause(1);        /* Reset Strobe */
          outb(0x0A,ppc);Pause(1);        /* PreRdTimersLo */
          outb(0x0B,ppc);Pause(1);        /* RdTimersLo Strobe */
          dl=inb(pps)>>3;		  /* Low half byte */
          outb(9,ppc);   Pause(1);        /* RdTimersHi Strobe */
          dh=inb(pps)<<1;                 /* High half Strobe */
          outb(8,ppc);			  /* Reset Strobe */
          outb(0xC0,ppd);Pause(1);        /* End CS */
          outb(2,ppc);   Pause(1);        /* PreWrAddress */
          outb(3,ppc);   Pause(1);        /* WrAddress Strobe */
          outb(2,ppc);   Pause(1);        /* Reset Strobe */
	  return ((dl&0x0F)|(dh&0xF0));
}

unsigned char GateReady()
{
    return (inb(pps)&0x80==0x80);
}

void Strobe()
{
          outb(4,ppc); Pause(1);
          outb(5,ppc); Pause(1);
          outb(4,ppc);
}


unsigned char Gateon()
{
    return ((inb(pps)&0x80)==0);
}

unsigned char Gateof()
{
    return ((inb(pps)&0x80));
}

void StartGate()
{
          outb(6,ppc); Pause(1);
          outb(7,ppc); Pause(1);
          outb(6,ppc);
	  while (Gateof());
}
