#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <sys/io.h>
#include <signal.h>

#define GateTimeOut 196		/* 96 */
#define PauseTime 2		/* Pause time in microseconds */

char lztmp[768];		/* Temporary strings buffer for "lz" 
				( 255 records ) */
unsigned char lzpos=0;		// Position in lztmp buffer
unsigned short int **dbuf;	// Data Buffer
char **tbuf;			// Time Buffer

#include "utils.h"
#include "config.h"
#include "files.h"

#include "visio.h"
#include "cs.h"

#include "lowlevel.h"
#include "hilevel.h"


unsigned char ExitFlag=1;	// Exit Key Pressed
void Stop(int n)
{
    printf("Exiting...\n");
    ExitFlag=0;
}


int main()
{
    FILE *f;			// Output file
    unsigned long i;		// Counter
    unsigned short int Gate;
    
	// Initialisation
    Setup();	

	// Timers    
    Gate=128*tint-GateTimeOut;
    kg=128.*tint/Gate;
    
	// Getting memory
    dbuf=(unsigned short int**)malloc(tfint*sizeof(unsigned short int*));
    tbuf=(char**)malloc(tfint*sizeof(char*));
    for (i=0;i<tfint;i++)
    {
	dbuf[i]=(unsigned short int*)malloc((nch+11)*sizeof(unsigned short int));
	tbuf[i]=(char*)malloc(15*sizeof(char));
    }
	// Initialisation
    InitialisePorts();
    InitCounter(0,1);				// Timer0 as One Shot
    LoadCounter(0,Gate);			// Interval = Gate/128 s
    for (i=0;i<nch;i++) InitCounter(i+1,0);	// Timers 1..nch as counters
    ResetCounters(nch);
	// Ctrl+C Signal Handler
    signal(SIGINT,Stop);
	// Creating File
    f=Openfile(0);
    fclose(f);
    
	// Initialising Network Servers
    CSInitialise();

	// Main Loop
    printf("\nPress Cntrl+C to exit\n");
    while (ExitFlag)
    {
	    // Main Action
	printf("1:%lu.%lu\n", getminutes(),getseconds());
	ProcTIMERS();
	printf("2:%lu.%lu\n", getminutes(),getseconds());
	ClientServer();
	printf("3:%lu.%lu\n", getminutes(),getseconds());
	WriteFile();
	    // Visualisation ( Off )
	printf("4:%lu.%lu\n", getminutes(),getseconds());
	Display();
	printf("5:%lu.%lu\n", getminutes(),getseconds());
    }
    
    if (BufPos) 
    {
	f=fopen(filnam,"a+");
        SaveData(f,BufPos-1);
    }

	// DeInitialising Network Servers
    CSRelease();
    
	// Realising memory
    for (i=0;i<tfint;i++)
    {
	free(dbuf[i]);
	free(tbuf[i]);
    }
    free(dbuf);
    free(tbuf);
    return 0;
}
