unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, Db, ADODB, StdCtrls, DateUtils, RegExpr, Variants, DBClient,
  OleServer, ExcelXP;
{       
       
     ADOConnection1: TADOConnection;
    ADOCommand1: TADOCommand;
    ADODataSet1.Connection:=ADOConnection1;
    DataSource1.DataSet:=ADODataSet1;
    DBGrid1.DataSource:=DataSource1;}

type
  TForm2 = class(TForm)
    ADOConnection1: TADOConnection;
    ADOCommand1: TADOCommand;
    ADODataSet1: TADODataSet;
    DataSource1: TDataSource;
    GroupBox1: TGroupBox;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    GroupBox2: TGroupBox;
    DBGrid1: TDBGrid;
    Button3: TButton;
    ClientDataSet1: TClientDataSet;
    Button4: TButton;
    ClientDataSet2: TClientDataSet;
    ExcelApplication1: TExcelApplication;
    Button5: TButton;
    Button6: TButton;
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SendToExcel(ds: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

uses Unit1, Unit3, Unit4;

{$R *.DFM}

{
    Original
  Form2.ADODataSet1.Recordset := AdoConnection1.Commands[0].Execute;
    Fields
}
procedure TForm2.Button3Click(Sender: TObject);
var
  str: TStringList;
  i,j,k: Integer;
  row: array of array of Variant;
  fields: array of Variant;
  ds : TADODataset;
  re: TRegExpr;
  size: Integer;
  title: Widestring;
begin
  str := TStringList.Create();
  Form1.GetClassDatabases(Form2.Caption, str);

  ds := TADODataset.Create(self);

  re := TRegExpr.Create;
  re.Expression := 'Initial Catalog=[^;]+;';
  ds.ConnectionString := re.Replace(Form1.Edit1.Text,'Initial Catalog=' + str.Strings[0] + ';',true);
  ds.CommandText := 'SELECT ValueID, ValueName FROM [dbo].[Archive] ORDER BY ValueID ASC';
  ds.Active:=True;

  fields := VarArrayCreate([0, 1], varVariant);
  fields[0] := 'ValueID';
  fields[1] := 'ValueName';

  re.Expression := '\s+$';
  with Form2.ClientDataSet1.FieldDefs do
  begin
    Clear;
    Add('Timestamp',ftDateTime, 0);
    size:=0;
    while (not(ds.Recordset.EOF)) do
    begin
      row := ds.Recordset.GetRows(1, ds.Recordset.Bookmark, fields);
      title := re.Replace(row[1][0],'',false);
      Add(title{IntToStr(size)}, ftFloat, 0);
      size:=size+1;
    end;
    Form2.ClientDataSet1.Close;
    Form2.ClientDataSet1.CreateDataSet;
  end;
  ds.Destroy;

  fields[0] := 'TimeStamp';
  fields[1] := 'RealValue';

  re.Expression := '^([^,]+),[^,]*,';
  for k:=1 to size do
  begin
    ADOCommand1.CommandText := re.Replace(Edit1.Text,'$1,' + IntToStr(k) + ',', True);

//    ShowMessage(ADOCommand1.CommandText);
    Form2.ClientDataSet1.First;

    for i:=0 to str.Count-1 do
    begin
      ADOConnection1.ConnectionString := Form1.Edit2.Text + 'Catalog=' + str.Strings[i] + ';';
      ADOConnection1.Connected := True;

      Form2.ADODataSet1.Recordset := AdoConnection1.Commands[0].Execute;

      while (not(Form2.ADODataSet1.Recordset.EOF)) do
      begin
        row := Form2.ADODataSet1.Recordset.GetRows(1, Form2.ADODataSet1.Recordset.Bookmark, fields);
        with (Form2.ClientDataSet1) do
        begin
          if k=1 then
          begin
            Append;
            Fields[0].AsDateTime := row[0][0];
            Fields[k].AsFloat := row[1][0];
          end
          else
          begin
            Edit;
            Fields[k].AsFloat := row[1][0];
            Next;
          end;
        end;
      end;
      ADOConnection1.Close;
    end;
   end;

  for k:=1 to size do
  begin
      Form2.DBGrid1.Columns.Items[k].Width:=128;
  end;

  GroupBox2.Caption :='Records read  ' + Inttostr(ClientDataSet1.RecordCount);

  re.Destroy;
  str.Destroy;
end;

procedure TForm2.Button1Click(Sender: TObject);
var
  str: TStringList;
  i,j: Integer;
  row: array of array of Variant;
  fields: array of Variant;
begin
  Form2.ADOCommand1.CommandText := Edit1.Text;
  str := TStringList.Create();
  Form1.GetClassDatabases(Form2.Caption, str);

  for i:=0 to str.Count-1 do
  begin
   ADOConnection1.ConnectionString := Form1.Edit2.Text + 'Catalog=' + str.Strings[i] + ';';
   ADOConnection1.Connected := True;

   Form2.ADODataSet1.Recordset := AdoConnection1.Commands[0].Execute;

    if i=0 then
    begin
      fields := VarArrayCreate([0, Form2.ADODataSet1.FieldCount -1], varVariant);
      with Form2.ClientDataSet1.FieldDefs do
      begin
        Clear;
        for j:=0 to Form2.ADODataSet1.FieldCount-1 do
        begin
          Add(Form2.ADODataSet1.FieldDefs.Items[j].Name,Form2.ADODataSet1.FieldDefs.Items[j].DataType,Form2.ADODataSet1.FieldDefs.Items[j].Size);
          fields[j] := Form2.ADODataSet1.FieldDefs.Items[j].Name;
        end;
      end;
      Form2.ClientDataSet1.Close;
      Form2.ClientDataSet1.CreateDataSet;
    end;

    while (not(Form2.ADODataSet1.Recordset.EOF)) do
    begin
      row := Form2.ADODataSet1.Recordset.GetRows(1, Form2.ADODataSet1.Recordset.Bookmark, fields);

      with (Form2.ClientDataSet1) do
      begin
        Append;
        for j:=0 to FieldCount-1 do
        begin
          Fields[j].AsVariant := row[j][0];
        end;
      end;
    end;
    ADOConnection1.Close;
   end;
 
  GroupBox2.Caption :='Records read  ' + Inttostr(ClientDataSet1.RecordCount);

  str.Destroy;
end;


procedure TForm2.Button2Click(Sender: TObject);
begin
  Form3.ShowModal;
end;

procedure TForm2.FormActivate(Sender: TObject);
var
  s: Widestring;
  s1: String;
begin
  //   
// s:='Provider=WinCCOLEDBProvider.1;Data Source=.\WinCC;Catalog=' + Form1.Combobox1.Text + ';';
// ADOConnection1.ConnectionString := s;
  form1.Hide;

  DateTimeToString(s1,'yyyy-MM-dd HH:mm:ss',Tomorrow);
  form2.Edit1.Text := 'TAG:R,1,1980-01-01 00:00:00, ' + s1;
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Form2.ClientDataSet1.Close;
   ADOConnection1.Cancel;
   ADOConnection1.Connected := False;
   ADOConnection1.ConnectionString := '';
   Form2.GroupBox2.Caption := 'Records read ';
   form1.Show;
end;

procedure TForm2.Button4Click(Sender: TObject);
var
  str: TStringList;
  i,j,k: Integer;
  ddata: array of Double;
  dt: array of TDateTime;
  pos,records,allocated: Integer;
  ds : TADODataset;
  re: TRegExpr;
  size: Integer;
  title: Widestring;
  bigstep, step: Double;
  bigcount, count: Double;
  const count_interval = 1;
  const show_time = 1;
begin
  DataSource1.DataSet := ClientDataSet2;
  Form4:=TForm4.Create(self);
  Form4.Show;

  str := TStringList.Create();
  Form1.GetClassDatabases(Form2.Caption, str);

  ds := TADODataset.Create(self);

  re := TRegExpr.Create;
  re.Expression := 'Initial Catalog=[^;]+;';
  ds.ConnectionString := re.Replace(Form1.Edit1.Text,'Initial Catalog=' + str.Strings[0] + ';',true);
  ds.CommandText := 'SELECT ValueID, ValueName FROM [dbo].[Archive] ORDER BY ValueID ASC';
  ds.Active:=True;

  re.Expression := '\s+$';
  with Form2.ClientDataSet1.FieldDefs do
  begin
    Clear;
    Add('Timestamp',ftDateTime, 0);
    size:=0;
    while (not(ds.Recordset.EOF)) do
    begin
      title := re.Replace(ds.Fields[1].Value,'',false);
      Add(title{IntToStr(size)}, ftFloat, 0);
      size:=size+1;
      ds.Next;
    end;
    Form2.ClientDataSet1.Close;
    Form2.ClientDataSet1.CreateDataSet;
  end;
  ds.Destroy;

  allocated := 0;
//  size := 2;

  bigstep := 100.0 / str.Count;
  step := count_interval * bigstep / (size + show_time);
  bigcount := 0;

  re.Expression := '^([^,]+),[^,]*,';
  for i:=0 to str.Count-1 do
  begin
    ADOConnection1.ConnectionString := Form1.Edit2.Text + 'Catalog=' + str.Strings[i] + ';';

    count := 0;
    for k:=1 to size do
    begin
      ADOCommand1.CommandText := re.Replace(Edit1.Text,'$1,' + IntToStr(k) + ',', True);
      ADOConnection1.Connected := True;

      Form2.ADODataSet1.Recordset := AdoConnection1.Commands[0].Execute;

      if k = 1 then
      begin
        records := Form2.ADODataSet1.Recordset.RecordCount;
        if (records > allocated) then
        begin
          SetLength(ddata,size*records);
          SetLength(dt,records);
          allocated := records;
        end;
        pos := 0;
        j := 0;
      end;

      while (not(Form2.ADODataSet1.Recordset.EOF)) do
      begin
        ddata[pos] := Form2.ADODataSet1.Fields[2].Value;
        pos := pos + 1;
        if k=1 then
        begin
          dt[j] := Form2.ADODataSet1.Fields[1].Value;
          j := j + 1;
        end;
        Form2.ADODataSet1.Next;
      end;

      ADOConnection1.Close;

      if ((k mod count_interval)=0) then
      begin
        count := count + step;
        Form4.ProgressBar1.Position := round(bigcount+count);
      end;
    end;

    with (Form2.ClientDataSet1) do
    begin
      for j:=0 to records-1 do
      begin
        pos := j;
        
        Append;
        Fields[0].AsDateTime := dt[j];
        for k:=1 to size do
        begin
          Fields[k].AsFloat := ddata[pos];
          pos := pos + records;
        end;
      end;
    end;

    bigcount := bigcount + bigstep;
    Form4.ProgressBar1.Position := round(bigcount);
  end;


  re.Destroy;
  str.Destroy;

  Form4.Destroy;
  Form4.Hide;
  DataSource1.DataSet := ClientDataSet1;

  for k:=1 to size do
  begin
      Form2.DBGrid1.Columns.Items[k].Width:=128;
  end;

  GroupBox2.Caption :='Records read  ' + Inttostr(ClientDataSet1.RecordCount);
end;


procedure TForm2.SendToExcel(ds: TDataSet);
var
  r: ExcelXP.ExcelRange;
  i: Integer;
  row: Integer;
begin
  Form4:=TForm4.Create(self);
  Form4.Show;

  with (Form2.ExcelApplication1) do
  begin
    Connect;
    Workbooks.Add(NULL, 0);

    r:=ActiveCell;
    for i:=0 to ds.Fields.Count - 1 do
    begin
      r.Value[xlRangeValueDefault] := ds.Fields[i].DisplayLabel;
      r:=r.Next;
    end;

    Form4.ProgressBar1.Position := round(100/(ds.RecordCount+1));

    row := 2;

    ds.DisableControls;
    ds.First;
    while not ds.EOF do
    begin
      r:=Range['A'+IntToStr(row), EmptyParam];
      for i:=0 to ds.Fields.Count - 1 do
      begin
        r.Value[xlRangeValueDefault] := ds.Fields[i].AsString;
        r:=r.Next;
      end;
      ds.Next;
      Inc(row);

      Form4.ProgressBar1.Position := round(100*row/(ds.RecordCount+1));

    end;
    ds.EnableControls;

    Visible[0]:=True;
    Disconnect;
  end;
  Form4.Destroy;
  Form4.Hide;
end;

procedure TForm2.Button5Click(Sender: TObject);
begin

  SendToExcel(ClientDataSet1);
end;

procedure TForm2.Button6Click(Sender: TObject);
var
  str: TStringList;
  i,j,k: Integer;
  ddata: array of Double;
  dt: array of TDateTime;
  pos,records,allocated: Integer;
  ds : TADODataset;
  re: TRegExpr;
  size: Integer;
  title: Widestring;
  bigstep, step: Double;
  bigcount, count: Double;
  saveDialog : TSaveDialog;
  F: System.Text;

  const count_interval = 1;
  const show_time = 1;
begin
 saveDialog := TSaveDialog.Create(self);
 saveDialog.Title := 'Export the data';
 saveDialog.Filter := 'CSV File|*.csv';
 saveDialog.DefaultExt := 'csv';
 saveDialog.FilterIndex := 1;
 if (saveDialog.Execute()) then
 begin
  System.assign(F,saveDialog.FileName);
  Rewrite(F);
  Form4:=TForm4.Create(self);
  Form4.Show;

  str := TStringList.Create();
  Form1.GetClassDatabases(Form2.Caption, str);

  ds := TADODataset.Create(self);

  re := TRegExpr.Create;
  re.Expression := 'Initial Catalog=[^;]+;';
  ds.ConnectionString := re.Replace(Form1.Edit1.Text,'Initial Catalog=' + str.Strings[0] + ';',true);
  ds.CommandText := 'SELECT ValueID, ValueName FROM [dbo].[Archive] ORDER BY ValueID ASC';
  ds.Active:=True;

  re.Expression := '\s+$';
  Write(F, 'Timestamp');
  while (not(ds.Recordset.EOF)) do
  begin
    Write(F, ','+re.Replace(ds.Fields[1].Value,'',false));
    size:=size+1;
    ds.Next;
  end;
  Writeln(F);

  ds.Destroy;

  allocated := 0;

  bigstep := 100.0 / str.Count;
  step := count_interval * bigstep / (size + show_time);
  bigcount := 0;

  re.Expression := '^([^,]+),[^,]*,';
  for i:=0 to str.Count-1 do
  begin
    ADOConnection1.ConnectionString := Form1.Edit2.Text + 'Catalog=' + str.Strings[i] + ';';

    count := 0;
    for k:=1 to size do
    begin
      ADOCommand1.CommandText := re.Replace(Edit1.Text,'$1,' + IntToStr(k) + ',', True);
      ADOConnection1.Connected := True;

      Form2.ADODataSet1.Recordset := AdoConnection1.Commands[0].Execute;

      if k = 1 then
      begin
        records := Form2.ADODataSet1.Recordset.RecordCount;
        if (records > allocated) then
        begin
          SetLength(ddata,size*records);
          SetLength(dt,records);
          allocated := records;
        end;
        pos := 0;
        j := 0;
      end;

      while (not(Form2.ADODataSet1.Recordset.EOF)) do
      begin
        ddata[pos] := Form2.ADODataSet1.Fields[2].Value;
        pos := pos + 1;
        if k=1 then
        begin
          dt[j] := Form2.ADODataSet1.Fields[1].Value;
          j := j + 1;
        end;
        Form2.ADODataSet1.Next;
      end;
      ADOConnection1.Close;

      if ((k mod count_interval)=0) then
      begin
        count := count + step;
        Form4.ProgressBar1.Position := round(bigcount+count);
      end;
    end;

    for j:=0 to records-1 do
    begin
      pos := j;
      Write(F,DateTimeToStr(dt[j]));
      for k:=1 to size do
      begin
        Write(F,',');
        Write(F, ddata[pos]);
        pos := pos + records;
      end;
      Writeln(F);
    end;

    bigcount := bigcount + bigstep;
    Form4.ProgressBar1.Position := round(bigcount);
  end;


  re.Destroy;
  str.Destroy;

  Form4.Destroy;
  Form4.Hide;
  System.Close(F);
 end;

end;

end.
