#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <signal.h>

#include "pfcam.h"

#define DLLNAME "libFullAreaGray8.so"
#define read_socket "/tmp/pfserver.socket"


int port = 0;

int handleError(error)
{
	const char *s;

	s = pfGetErrorString(error);
	if (error < 0) {
		printf("Error: %s\n", s);
	} else {
		printf("Warning: %s\n", s);
	}
	return error;
}


int request(char *data, const char *prop, const char *val) {
    int error, warn;
    char name[50], manu[50];
    int mBytes, nBytes, version, type;
    TOKEN t;


    //show info about port to open
    pfPortInfo(port, manu, &mBytes, name, &nBytes, &version, &type);

    //open port:
    error = pfDeviceOpen(port);
    if (error < 0) {
        handleError(error);
        return -1;
    }
    else {
        warn = error;
    }


    //Check if higher baud rate is supported
    error = pfIsBaudRateSupported(port, 115200);
    if (error == 1) {
        error = pfSetBaudRate(port, 115200);
        if (error < 0) {
            handleError(error);
            pfDeviceClose(port);
            return -1;
        }
    } else {
        error = pfIsBaudRateSupported(port, 57600);
        if (error == 1){
            error = pfSetBaudRate(port, 57600);
            if (error < 0){
                handleError(error);
                pfDeviceClose(port);
                return -1;
            }
        }
    }

    t = pfProperty_ParseName(port, prop);
    if (t == INVALID_TOKEN) {
        printf("Property '%s' not found or bad index\n", prop);
        pfDeviceClose(port);
        return -1;
    }

    if (val) {
        error = pfDevice_SetProperty_String(port, t, val);
        if (error >= 0) {
            error = pfDevice_GetProperty_String(port, t, data, 64);
        }
    } else {
        error = pfDevice_GetProperty_String(port, t, data, 64);
    }

    if (error < 0) {
        handleError(error);
        pfDeviceClose(port);
        return -1;
    } else {
        warn = error;
    }


    if (warn){
        handleError(warn);
    }
    pfDeviceClose(port);
    return 0;
}


int main(int argc, char * argv[]) {
    int err;
    char *tmp;
    char data[64];
    int arg;

    int numOfPorts;

    signal (SIGPIPE, SIG_IGN);

    pfPortInit(&numOfPorts);

    if (argc > 1){
        arg = strtoul(argv[1], &tmp, 10);
        if (!*tmp){
            port = arg;
            if (port >= numOfPorts){
                port = 0;
            }
        }
    }

    unlink(read_socket);

    // Open sockets for reading and writing?!
    //
    int sockRead = socket (PF_UNIX, SOCK_STREAM, 0);
    int on = 1;

    if ( setsockopt( sockRead, SOL_SOCKET, SO_REUSEADDR,
                     (const char *) &on, sizeof(on)   ) < 0)
        perror("setsockopt(...,SO_REUSEADDR,...)");

    // Give the socket a name.
    struct sockaddr_un name;
    memset(&name, 0, sizeof(name));
    name.sun_family = AF_UNIX;
    strncpy(name.sun_path,read_socket,sizeof(name.sun_path));
    name.sun_path[sizeof(name.sun_path)-1]=0;

    if (bind (sockRead, (struct sockaddr *) &name, sizeof (name)) < 0)
        perror ("bind");

    // Listen to the ports
    if (listen (sockRead, 10) < 0)
        perror ("listen");

    chmod(read_socket, 0666);

    // Add to select set?!
    fd_set active_fd_set;
    fd_set select_fd_set;

    FD_ZERO (&active_fd_set);
    FD_SET (sockRead, &active_fd_set);

    // Server loop
    size_t size;
    struct sockaddr_un clientname;
    int sockNew;
    char msg[2048];
    int status;

    while (1) {
        select_fd_set = active_fd_set;

        status = select (FD_SETSIZE, &select_fd_set, NULL, NULL, NULL);
        if ((status > 0)&&(FD_ISSET(sockRead, &select_fd_set))) {

            //printf("New client connected for reading from camera\n");
            size = sizeof (clientname);
            if ((sockNew = accept (sockRead,(struct sockaddr *) &clientname, &size)) < 0){
                perror ("accept");
            }

            //  Transmit the requested number of bytes from the calling side !!!
            int res;
            res = read(sockNew, msg, 2048);
            if (res>0) {
                msg[res] = 0; // Terminate string

                tmp = strchr(msg, ' ');
                if (tmp) *(tmp++) = 0;

                err = request(data, msg, tmp);
		    // retrying in case of error
		if (err) err = request(data, msg, tmp);
		
		if (err) strcpy(data, "-1");
            } else {
                strcpy(data, "-1");
            }

            write(sockNew, data, strlen(data));

            close(sockNew);
        } // end of status > 0
    }

    return(0);
}
