#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <gtk/gtk.h>

#define Max 10000
#define Buf(y,x) NBuffer[(y)*X+(x)]
#define B(y,x) Buffer[(y)*X+(x)]

float *Buffer=NULL;
float *NBuffer=NULL;
float VMax=0;
unsigned long X;
unsigned long Y;
unsigned long InvertFlag=0;
GtkWidget *LnFlag;
GtkWidget *Enable1;
GtkWidget *Enable2;
GtkWidget *Enable3;
GtkWidget *Enable4;
GtkWidget *Enable5;
GtkMenu *NMenu;
GtkMenu *ShowLC;
GtkMenu *Norm01;
GtkObject *XSize;
GtkObject *YSize;
GtkObject *Width;
GtkObject *Show;
GdkGC *gc;
GdkColormap *ColorMap;
GdkColor *Colors;
GdkColor *LColor;
GdkFont *Font;
GdkFont *LFont;
GtkWidget *DrawArea1;
GtkWidget *DrawArea2;
GtkWidget *WidthBut;

struct BmpHeader
{
	unsigned short int Sign;
	unsigned long fSize;
	unsigned long Reserved;
	unsigned long Ptr;
	unsigned long hSize;
	unsigned long Width;
	unsigned long Height;
	unsigned short int Planes;
	unsigned short int BPP;			// Bites Per Pixel
	unsigned long int RLE;			// 0,1,2
	unsigned long bSize;
	unsigned long XRes;
	unsigned long YRes;
	unsigned long Colors;
	unsigned long sColors;
	struct RGB *Pallete;
	unsigned long RWidth;
};

gint delete_event(GtkWidget *widget, GdkEvent  *event, gpointer data)
{
	gtk_main_quit();
	return(FALSE);
}

gint SetEEFlag(GtkWidget *widget, unsigned char *ExitFlag)
{
	*ExitFlag=0;
}

gint PrintError(gchar *Message, unsigned char isGtk)
{
	GtkWidget *Tmp;
	GtkWidget *Dialog;
	unsigned char ExitFlag=1;

	Dialog=gtk_dialog_new();
    gtk_signal_connect (GTK_OBJECT (Dialog), "delete_event",GTK_SIGNAL_FUNC (delete_event),NULL);
	gtk_window_set_modal(GTK_WINDOW(Dialog),TRUE);
	gtk_window_set_default_size(GTK_WINDOW(Dialog),350,200);
	gtk_window_set_title(GTK_WINDOW(Dialog),"Error Message");
	gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(Dialog)->vbox),10);
	gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(Dialog)->vbox),10);
	Tmp=gtk_button_new_with_label("OK");
	gtk_signal_connect_object(GTK_OBJECT(Tmp),"clicked",
				GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(Dialog));
    gtk_signal_connect_object(GTK_OBJECT(Tmp), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(Dialog));
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(Dialog)->action_area),Tmp);

	Tmp=gtk_label_new(Message);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog)->vbox),Tmp,TRUE,TRUE,0);
	gtk_widget_show_all(Dialog);
	gtk_main();
}

void ISureF(GtkWidget *widget, unsigned char *Flag)
{
	*Flag=1;
}

gboolean AreYouSureF(gchar *Message)
{
	GtkWidget *Tmp;
	GtkWidget *Dialog;
	unsigned char ExitFlag=0;

	Dialog=gtk_dialog_new();
    gtk_signal_connect (GTK_OBJECT (Dialog), "delete_event",GTK_SIGNAL_FUNC (delete_event),NULL);
	gtk_window_set_modal(GTK_WINDOW(Dialog),TRUE);
	gtk_window_set_default_size(GTK_WINDOW(Dialog),350,200);
	gtk_window_set_title(GTK_WINDOW(Dialog),"Are You Sure?");
	gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(Dialog)->vbox),10);
	gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(Dialog)->vbox),10);

	Tmp=gtk_button_new_with_label("Yes");
	gtk_signal_connect(GTK_OBJECT(Tmp),"clicked",GTK_SIGNAL_FUNC(ISureF),&ExitFlag);
	gtk_signal_connect_object(GTK_OBJECT(Tmp),"clicked",
				GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(Dialog));
    gtk_signal_connect_object(GTK_OBJECT(Tmp), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(Dialog));
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(Dialog)->action_area),Tmp);

	Tmp=gtk_button_new_with_label("No");
	gtk_signal_connect_object(GTK_OBJECT(Tmp),"clicked",
				GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(Dialog));
    gtk_signal_connect_object(GTK_OBJECT(Tmp), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(Dialog));
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(Dialog)->action_area),Tmp);

	Tmp=gtk_label_new(Message);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog)->vbox),Tmp,TRUE,TRUE,0);
	gtk_widget_show_all(Dialog);
	gtk_main();
	return ExitFlag;
}

void WriteHeader(BmpHeader *bh, FILE *o)
{
	fwrite(&bh->Sign,2,1,o);
	fwrite(&bh->fSize,4,1,o);
	fwrite(&bh->Reserved,4,1,o);
	fwrite(&bh->Ptr,4,1,o);
	fwrite(&bh->hSize,4,1,o);
	fwrite(&bh->Width,4,1,o);
	fwrite(&bh->Height,4,1,o);
	fwrite(&bh->Planes,2,1,o);
	fwrite(&bh->BPP,2,1,o);
	fwrite(&bh->RLE,4,1,o);
	fwrite(&bh->bSize,4,1,o);
	fwrite(&bh->XRes,4,1,o);
	fwrite(&bh->YRes,4,1,o);
	fwrite(&bh->Colors,4,1,o);
	fwrite(&bh->sColors,4,1,o);
};

gint SaveFileName(GtkWidget *Widget, gchar **stmp)
{
	*stmp=(char*)malloc(255);
	strcpy(*stmp,gtk_file_selection_get_filename(GTK_FILE_SELECTION(gtk_widget_get_toplevel(Widget))));
}

gint ExitFunction(GtkWidget *Widget, unsigned char *ExitFlag)
{
	*ExitFlag=1;
}

void SaveF(GtkWidget *widget, GtkWidget *Draw)
{
	long i,j,k;
	unsigned long color,item2;
	unsigned iBlue,iGreen,iRed;
	unsigned long W=Draw->allocation.width;
	unsigned long H=Draw->allocation.height;
	unsigned char ExitFlag=0, EF2=1;
	char *stmp=NULL;
	FILE *f;

	while (EF2)
	{
		GtkWidget *FileSelection=gtk_file_selection_new("File To Save Bitmap");
		gtk_container_set_border_width(GTK_CONTAINER(FileSelection),10);
		gtk_window_set_modal(GTK_WINDOW(FileSelection),TRUE);
    	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
				"clicked", GTK_SIGNAL_FUNC(SaveFileName), &stmp);
    	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
				"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(FileSelection));
    	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->cancel_button),
				"clicked", GTK_SIGNAL_FUNC(ExitFunction), &ExitFlag);
    	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->cancel_button),
				"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(FileSelection));
		gtk_widget_show(FileSelection);

		while ((!stmp)&&(!ExitFlag))
			gtk_main_iteration();
		if (ExitFlag) return;
		if (!strstr(stmp,".bmp")) strcat(stmp,".bmp");
		f=fopen(stmp,"r");
		if (f)
		{
			EF2=!AreYouSureF("File Alredy Exist! Overwrite?");
			if (EF2)
			{
				free(stmp);
				stmp=NULL;
			}
			fclose(f);
		}
		else EF2=0;
	}

	f=fopen(stmp,"w");
	free(stmp);
	if (!f)
	{
		PrintError("Can't Open File!",1);
		return;
	}


	GdkImage *Image=gdk_image_get(Draw->window,0,0,W,H);
	if (!Image)
	{
		PrintError("Can't Allocate Memory!",1);
		fclose(f);
		return;
	}
	BmpHeader *bh=(BmpHeader*)malloc(sizeof(BmpHeader));

	if (!bh)
	{
		PrintError("Can't Allocate Memory!",1);
		gdk_image_destroy(Image);
		fclose(f);
		return;
	}

	/********************** Making BMP Header ****************************/
	bh->Sign=0x4d42;
	bh->fSize=666;//"filesize";
	bh->Reserved=0;
	bh->Ptr=666;//"image";
	bh->hSize=666;//"header size";
	bh->Width=W;
	bh->Height=H;
	bh->Planes=1;
	bh->BPP=24; //?
	bh->RLE=0;
	bh->bSize=666;// Image size in bytes;
	bh->XRes=0;
	bh->YRes=0;
	bh->Colors=0;
	bh->sColors=0;

	if ((bh->Width*bh->BPP)%32==0) bh->RWidth=bh->Width*bh->BPP/8;
	else bh->RWidth=((bh->Width*bh->BPP)/32+1)*4;
	bh->bSize=bh->RWidth*bh->Height;
	bh->hSize=40;
	bh->Ptr=14+bh->hSize;
	bh->fSize=bh->Ptr+bh->bSize;

	char *BmpBuf=(char *)malloc(bh->bSize);
	if (!BmpBuf)
	{
		PrintError("Can't Allocate Memory!",1);
		gdk_image_destroy(Image);
		free(bh);
		fclose(f);
		return;
	}

	for (i=bh->Height-1;i>=0;i--)
	 for (j=0;j<bh->Width;j++)
	 {
		color=gdk_image_get_pixel(Image,j,i);
		for (k=0;k<256;k++)
			if ((Colors[k].pixel)==color)
			{
				iBlue=Colors[k].blue/255;
				iGreen=Colors[k].green/255;
				iRed=Colors[k].red/255;
				k=260;
			}
		if (k<260)
		{
			iBlue=255;
			iGreen=255;
			iRed=255;
		}
		item2=(bh->Height-i-1)*bh->RWidth+j*3;
		BmpBuf[item2]=(unsigned char)(iBlue);
		BmpBuf[item2+1]=(unsigned char)(iGreen);
		BmpBuf[item2+2]=(unsigned char)(iRed);
	 }

	WriteHeader(bh,f);
	fwrite(BmpBuf,1,bh->bSize,f);
	fclose(f);
	free(bh);
	free(BmpBuf);

	gdk_image_destroy(Image);
}





gint Enable01F(GtkWidget *widget, GdkEvent  *event, gpointer data)
{
	gtk_widget_set_sensitive(Enable3,TRUE);
}

gint Disable01F(GtkWidget *widget, GdkEvent  *event, gpointer data)
{
	gtk_widget_set_sensitive(Enable3,FALSE);
}

gint WidthF(GtkWidget *widget, GtkWidget *Draw)
{
	unsigned char To01=g_list_index(GTK_MENU_SHELL(Norm01)->children,gtk_menu_get_active(Norm01));
	unsigned char NMethod=g_list_index(GTK_MENU_SHELL(NMenu)->children,gtk_menu_get_active(NMenu));
	if ((VMax>10)&&(NMethod==0))
	{
		GTK_ADJUSTMENT(Width)->upper=VMax;
		GTK_ADJUSTMENT(Width)->page_increment=VMax/20;
		if (GTK_ADJUSTMENT(Width)->value>VMax) GTK_ADJUSTMENT(Width)->value=VMax;
	}
	else if ((NMethod)&&(To01))
	{
		GTK_ADJUSTMENT(Width)->upper=1;
		GTK_ADJUSTMENT(Width)->page_increment=0.1;
		if (GTK_ADJUSTMENT(Width)->value>1) GTK_ADJUSTMENT(Width)->value=1;
	}
	else
	{
		GTK_ADJUSTMENT(Width)->upper=10;
		GTK_ADJUSTMENT(Width)->page_increment=0.2;
		if (GTK_ADJUSTMENT(Width)->value>10) GTK_ADJUSTMENT(Width)->value=10;
	}
	gtk_spin_button_update(GTK_SPIN_BUTTON(WidthBut));
}

gboolean DrawSF(GtkWidget *widget, GdkEventExpose *event, GtkWidget *Draw)
{
	unsigned H,W;
	double Xsize,Ysize;
	unsigned long i,j,k;
	unsigned x1,x2,y1,y2;
	double Value,PrevValue;
	double S=0,Q=0;
	char str[10];
	GdkColor Color;
	if (!Buffer) return TRUE;

	float Wid=GTK_ADJUSTMENT(Width)->value;
	unsigned char isColumn=g_list_index(GTK_MENU_SHELL(ShowLC)->children,gtk_menu_get_active(ShowLC));
	W=DrawArea1->allocation.width;
	H=DrawArea1->allocation.height;

 	gdk_window_clear_area(DrawArea1->window,0,0,W,H);

	Ysize=H/(2*Wid);
	gdk_color_black(ColorMap,&Color);
	gdk_gc_set_foreground(gc,&Color);
	gdk_draw_line(DrawArea1->window,gc,0,(unsigned)(H-Ysize*Wid),W,(unsigned)(H-Ysize*Wid));
	gdk_draw_line(DrawArea1->window,gc,0,H,0,0);
	gdk_gc_set_foreground(gc,&(Colors[255]));

	if (isColumn)
	{
		Xsize=W/Y;
		j=(unsigned long)GTK_ADJUSTMENT(Show)->value;
		for (i=0;i<Y;i++)
		{
			if (j) Value=Buf(i,j-1);
			else
			{
				for(Value=0,k=0;k<X;k++)
					Value+=Buf(i,k);
				Value/=X;
			}
			S+=Value;
			Value+=Wid;
			if (i>1)
			{
				x1=(unsigned)((i-1)*Xsize);
				x2=(unsigned)(i*Xsize);
				y1=(unsigned)(H-PrevValue*Ysize);
				y2=(unsigned)(H-Value*Ysize);
				gdk_draw_line(DrawArea1->window,gc,x1,y1,x2,y2);
			}
			PrevValue=Value;
		}
		S/=Y;
		if (Y>1)
		{
			for (i=0;i<Y;i++)
			{
				if (j) Value=Buf(i,j-1);
				else
				{
					for(Value=0,k=0;k<X;k++)
						Value+=Buf(i,k);
					Value/=X;
				}
				Q+=(Value-S)*(Value-S);
			}
			Q=sqrt(Q/(Y-1));
		}
		else Q=0;
	}
	else
	{
		Xsize=W/X;
		i=(unsigned long)GTK_ADJUSTMENT(Show)->value;
		for (j=0;j<X;j++)
		{
			if (i) Value=Buf(i-1,j);
			else
			{
				for(Value=0,k=0;k<Y;k++)
					Value+=Buf(k,j);
				Value/=Y;
			}
			S+=Value;
			Value+=Wid;
			if (j>1)
			{
				x1=(unsigned)((j-1)*Xsize);
				x2=(unsigned)(j*Xsize);
				y1=(unsigned)(H-PrevValue*Ysize);
				y2=(unsigned)(H-Value*Ysize);
				gdk_draw_line(DrawArea1->window,gc,x1,y1,x2,y2);
			}
			PrevValue=Value;
		}
		S/=X;
		if (X>1)
		{
			for (j=0;j<X;j++)
			{
				if (i) Value=Buf(i-1,j);
				else
				{
					for(Value=0,k=0;k<Y;k++)
						Value+=Buf(k,j);
					Value/=Y;
				}
				Q+=(Value-S)*(Value-S);
			}
			Q=sqrt(Q/(X-1));
		}
		else Q=0;
	}

	W=DrawArea2->allocation.width;
	H=DrawArea2->allocation.height;
 	gdk_window_clear_area(DrawArea2->window,0,0,W,H);
	gdk_gc_set_foreground(gc,&Color);
	sprintf(str,"Average: %.2lf",S);
	gdk_draw_text(DrawArea2->window,Font,gc,1,10,str,strlen(str));
	sprintf(str,"Sqr Dfl: %.2lf",Q);
	gdk_draw_text(DrawArea2->window,Font,gc,1,25,str,strlen(str));
}

gboolean DrawQF(GtkWidget *widget, GdkEventExpose *event, GtkWidget *Draw)
{
}

gboolean DrawF(GtkWidget *widget, GdkEventExpose *event, GtkWidget *Draw)
{
	unsigned long i,j;
	unsigned long W,H,WSize,HSize;
	long color;
	if (!Buffer) return TRUE;
	float Wid=GTK_ADJUSTMENT(Width)->value;

	W=Draw->allocation.width;
	H=Draw->allocation.height;
	WSize=W/X;
	HSize=H/Y;

	for (i=0;i<Y;i++)
	{
		for(j=0;j<X;j++)
		{
			color=(unsigned)(Buf(i,j)*128/Wid+128);	// [-Wid,Wid] normalised
			if (color<0) color=0;
 			if (color>255) color=255;
			if (InvertFlag) color=255-color;
			gdk_gc_set_foreground(gc,&(Colors[color]));
			gdk_draw_rectangle(Draw->window,gc,TRUE,j*WSize,i*HSize,WSize,HSize);
		}
	}
	return TRUE;
}

void NormaliseF(GtkWidget *widget, GtkWidget *Draw)
{
	unsigned long i,j;
	float S,Q,min,max;
	if (!Buffer) return;

	unsigned char To01=g_list_index(GTK_MENU_SHELL(Norm01)->children,gtk_menu_get_active(Norm01));
	unsigned char NMethod=g_list_index(GTK_MENU_SHELL(NMenu)->children,gtk_menu_get_active(NMenu));
	unsigned char lnFlag=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(LnFlag));
	switch (lnFlag)
	{
		case 0:
			memcpy(NBuffer,Buffer,X*Y*sizeof(float));
		break;
		case 1:
			for (i=0;i<X*Y;i++)
				NBuffer[i]=log(Buffer[i]);
		break;
	}

	switch (NMethod)
	{
		case 0:
		break;
		case 1:	// Lines
			for(i=0;i<Y;i++)
			{
				switch (To01)
				{
					case 0:

						if (X==1) // Error Handling
						{
							PrintError("Cant Be Normalised this way!",1);
							memcpy(NBuffer,Buffer,X*Y*sizeof(float));
							gtk_menu_set_active(GTK_MENU(NMenu),0);
							gtk_option_menu_set_history(GTK_OPTION_MENU(Enable4),0);
							Disable01F(widget,NULL,Draw);
							DrawF(widget,NULL,Draw);
							DrawSF(widget, NULL, Draw);
							return;
						}

						for (S=0,j=0;j<X;j++)
							S+=Buf(i,j);
						S/=X;
						for (Q=0,j=0;j<X;j++)
							Q+=(Buf(i,j)-S)*(Buf(i,j)-S);
						Q=sqrt(Q/(X-1));
					break;
					case 1:
						for (min=1E+10,max=-1E+10,j=0;j<X;j++)
						{
							if (Buf(i,j)<min) min=Buf(i,j);
							if (Buf(i,j)>max) max=Buf(i,j);
						}
						S=(max+min)/2;
						Q=(max-min)/2;
					break;
				}
				if (fabs(Q)<1E-10) // Error Handling
				{
						PrintError("Cant Be Normalised this way!",1);
						memcpy(NBuffer,Buffer,X*Y*sizeof(float));
						gtk_menu_set_active(GTK_MENU(NMenu),0);
						gtk_option_menu_set_history(GTK_OPTION_MENU(Enable4),0);
						Disable01F(widget,NULL,Draw);
						DrawF(widget,NULL,Draw);
						DrawSF(widget, NULL, Draw);
						return;
				}
				for (j=0;j<X;j++)
					Buf(i,j)=(Buf(i,j)-S)/Q;
			}
		break;
		case 2:	// Columns
			for(j=0;j<X;j++)
			{
				switch (To01)
				{
					case 0:
						if (Y==1) // Error Handling
						{
							PrintError("Cant Be Normalised this way!",1);
							memcpy(NBuffer,Buffer,X*Y*sizeof(float));
							gtk_menu_set_active(GTK_MENU(NMenu),0);
							gtk_option_menu_set_history(GTK_OPTION_MENU(Enable4),0);
							Disable01F(widget,NULL,Draw);
							DrawF(widget,NULL,Draw);
							DrawSF(widget, NULL, Draw);
							return;
						}

						for (S=0,i=0;i<Y;i++)
							S+=Buf(i,j);
						S/=Y;
						for (Q=0,i=0;i<Y;i++)
							Q+=(Buf(i,j)-S)*(Buf(i,j)-S);
						Q=sqrt(Q/(Y-1));
					break;
					case 1:
						for (min=1E+10,max=-1E+10,i=0;i<Y;i++)
						{
							if (Buf(i,j)<min) min=Buf(i,j);
							if (Buf(i,j)>max) max=Buf(i,j);
						}
						S=(max+min)/2;
						Q=(max-min)/2;
					break;
				}
				if (fabs(Q)<1E-10) // Error Handling
				{
						PrintError("Cant Be Normalised this way!",1);
						memcpy(NBuffer,Buffer,X*Y*sizeof(float));
						gtk_menu_set_active(GTK_MENU(NMenu),0);
						gtk_option_menu_set_history(GTK_OPTION_MENU(Enable4),0);
						Disable01F(widget,NULL,Draw);
						DrawF(widget,NULL,Draw);
						DrawSF(widget, NULL, Draw);
						return;
				}
				for (i=0;i<Y;i++)
					Buf(i,j)=(Buf(i,j)-S)/Q;
			}
		break;
		case 3:	// Matrix
			switch (To01)
			{
				case 0:
					if (X*Y==1) // Error Handling
					{
						PrintError("Cant Be Normalised this way!",1);
						memcpy(NBuffer,Buffer,X*Y*sizeof(float));
						gtk_menu_set_active(GTK_MENU(NMenu),0);
						gtk_option_menu_set_history(GTK_OPTION_MENU(Enable4),0);
						Disable01F(widget,NULL,Draw);
						DrawF(widget,NULL,Draw);
						DrawSF(widget, NULL, Draw);
						return;
					}

					for(i=0,S=0;i<X*Y;i++)
						S+=NBuffer[i];
					S/=X*Y;
					for(i=0,Q=0;i<X*Y;i++)
						Q+=(NBuffer[i]-S)*(NBuffer[i]-S);
					Q=sqrt(Q/(X*Y-1));
				break;
				case 1:
					for (min=1E+10,max=-1E+10,i=0;i<X*Y;i++)
					{
						if (NBuffer[i]<min) min=NBuffer[i];
						if (NBuffer[i]>max) max=NBuffer[i];
					}
					S=(max+min)/2;
					Q=(max-min)/2;
				break;
			}
			if (fabs(Q)<1E-10) // Error Handling
			{
				PrintError("Cant Be Normalised this way!",1);
				memcpy(NBuffer,Buffer,X*Y*sizeof(float));
				gtk_menu_set_active(GTK_MENU(NMenu),0);
				gtk_option_menu_set_history(GTK_OPTION_MENU(Enable4),0);
				Disable01F(widget,NULL,Draw);
				DrawF(widget,NULL,Draw);
				DrawSF(widget, NULL, Draw);
				return;
			}

			for(i=0;i<X*Y;i++)
				NBuffer[i]=(NBuffer[i]-S)/Q;
		break;
	}
	DrawF(widget,NULL,Draw);
	DrawSF(widget, NULL, Draw);
}


gint InvertF(GtkWidget *widget, GtkWidget *Draw)
{
	InvertFlag=!InvertFlag;
	DrawF(widget,NULL,Draw);
}



gint AdjF(GtkWidget *Widget, gpointer data)
{
	unsigned char isColumn=g_list_index(GTK_MENU_SHELL(ShowLC)->children,gtk_menu_get_active(ShowLC));
	if (isColumn)
		GTK_ADJUSTMENT(Show)->upper=X;
	else
		GTK_ADJUSTMENT(Show)->upper=Y;
	GTK_ADJUSTMENT(Show)->page_increment=GTK_ADJUSTMENT(Show)->upper/10;
}

gint Load(GtkWidget *widget, GtkWidget *Draw)
{
	unsigned i,j;
	double dtmp;
	char *stmp=NULL;
	unsigned char ExitFlag=0;
	FILE *f;
	GtkWidget *FileSelection=gtk_file_selection_new("Input Data File");
	gtk_container_set_border_width(GTK_CONTAINER(FileSelection),10);
	gtk_window_set_modal(GTK_WINDOW(FileSelection),TRUE);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
				"clicked", GTK_SIGNAL_FUNC(SaveFileName), &stmp);
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
				"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(FileSelection));
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->cancel_button),
				"clicked", GTK_SIGNAL_FUNC(ExitFunction), &ExitFlag);
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->cancel_button),
				"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(FileSelection));
	gtk_widget_show(FileSelection);

	while ((!stmp)&&(!ExitFlag))
			gtk_main_iteration();
	if (ExitFlag) return 0;
	f=fopen(stmp,"r");
	if (!f)
	{
		PrintError("Can't Open File!",1);
		free(stmp);
		return 0;
	}

	X=(unsigned long)GTK_ADJUSTMENT(XSize)->value;
	Y=(unsigned long)GTK_ADJUSTMENT(YSize)->value;
	if (Buffer) free(Buffer);
	Buffer=(float*)malloc(X*Y*sizeof(float));
	if (!Buffer)
	{
		PrintError("Can't Allocate Memory!",1);
		free(stmp);
		fclose(f);
		return 0;
	}
	if (NBuffer) free(NBuffer);
	NBuffer=(float*)malloc(X*Y*sizeof(float));
	if (!NBuffer)
	{
		PrintError("Can't Allocate Memory!",1);
		free(stmp);
		fclose(f);
		free(Buffer);
		Buffer=NULL;
		return 0;
	}
	VMax=0;
	for (i=0;i<Y;i++)
	{
		for(j=0;j<X;j++)
		{
			if (fscanf(f,"%lf",&dtmp)!=1)
			{
				PrintError("Error Loading Input Data File!",1);
				free(stmp);
				fclose(f);
				free(Buffer);
				Buffer=NULL;
				free(NBuffer);
				NBuffer=NULL;
				return 0;
			}
			B(i,j)=dtmp;
			if (fabs(dtmp)>VMax) VMax=fabs(dtmp);
		}
		fgets(stmp,255,f);
	}
	free(stmp);
	fclose(f);
	NormaliseF(widget,Draw);
	AdjF(widget,Draw);
	WidthF(widget,Draw);
	gtk_widget_set_sensitive(Enable1,TRUE);
	gtk_widget_set_sensitive(Enable2,TRUE);
	gtk_widget_set_sensitive(Enable5,TRUE);
}

gint ProxyF(GtkWidget *widget, GtkWidget *Draw)
{
	DrawF(widget,NULL,Draw);
	DrawSF(widget,NULL,Draw);
}

gboolean DrawLogo(GtkWidget *widget, GdkEventExpose *event, GtkWidget *Draw)
{
	gdk_gc_set_foreground(gc,LColor);
	gdk_draw_text(Draw->window,LFont,gc,Draw->allocation.width-45,Draw->allocation.height-3,"DarkSoft",8);
	return TRUE;
}

int main(int argc, char *argv[])
{
	GtkWidget *window;
	GtkWidget *DrawArea;
	GtkWidget *HBox;
	GtkWidget *VBox;
	GtkWidget *Box;
	GtkWidget *Button;
	GtkWidget *Tmp;
	GtkWidget *Menu;
	GtkWidget *MenuItem;

	gtk_init (NULL,NULL);//&argc, &argv);
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(window)," - !");
	gtk_signal_connect (GTK_OBJECT (window), "delete_event", GTK_SIGNAL_FUNC (delete_event), NULL);
	gtk_widget_show(window);
	HBox=gtk_hbox_new(FALSE,5);

	VBox=gtk_vbox_new(FALSE,5);

	DrawArea=gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(DrawArea),200,100);
	gtk_signal_connect(GTK_OBJECT(DrawArea),"expose_event",GTK_SIGNAL_FUNC(DrawF),DrawArea);
	gtk_widget_show(DrawArea);
	gtk_box_pack_start(GTK_BOX(VBox),DrawArea,TRUE,TRUE,10);

	Tmp=gtk_hseparator_new();
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(VBox),Tmp,FALSE,FALSE,5);

	Box=gtk_hbox_new(FALSE,5);

	DrawArea1=gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(DrawArea1),50,100);
	gtk_signal_connect(GTK_OBJECT(DrawArea1),"expose_event",GTK_SIGNAL_FUNC(DrawSF),DrawArea);
	gtk_widget_show(DrawArea1);
	gtk_box_pack_start(GTK_BOX(Box),DrawArea1,TRUE,TRUE,5);

	Tmp=gtk_vseparator_new();
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,0);

	DrawArea2=gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(DrawArea2),50,100);
	gtk_signal_connect(GTK_OBJECT(DrawArea2),"expose_event",GTK_SIGNAL_FUNC(DrawSF),DrawArea);
	gtk_widget_show(DrawArea2);
	gtk_box_pack_start(GTK_BOX(Box),DrawArea2,TRUE,TRUE,5);

	gtk_widget_show(Box);
	gtk_box_pack_start(GTK_BOX(VBox),Box,TRUE,TRUE,10);
	gtk_widget_show(VBox);
	gtk_box_pack_start(GTK_BOX(HBox),VBox,TRUE,TRUE,15);

	Tmp=gtk_vseparator_new();
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(HBox),Tmp,FALSE,FALSE,0);

/************************************** Menu **********************************************/
	VBox=gtk_vbox_new(FALSE,5);

	Button=gtk_button_new_with_label("Load");
	gtk_signal_connect(GTK_OBJECT(Button),"clicked",GTK_SIGNAL_FUNC(Load),DrawArea);
	gtk_widget_show(Button);
	gtk_box_pack_start(GTK_BOX(VBox),Button,FALSE,FALSE,0);

	Button=gtk_button_new_with_label("Draw");
	gtk_widget_set_sensitive(Button,FALSE);
	Enable2=Button;
	gtk_signal_connect(GTK_OBJECT(Button),"clicked",GTK_SIGNAL_FUNC(ProxyF),DrawArea);
	gtk_widget_show(Button);
	gtk_box_pack_start(GTK_BOX(VBox),Button,FALSE,FALSE,0);

	Button=gtk_button_new_with_label("Save");
	gtk_widget_set_sensitive(Button,FALSE);
	Enable5=Button;
	gtk_signal_connect(GTK_OBJECT(Button),"clicked",GTK_SIGNAL_FUNC(SaveF),DrawArea);
	gtk_widget_show(Button);
	gtk_box_pack_start(GTK_BOX(VBox),Button,FALSE,FALSE,0);

	Button=gtk_button_new_with_label("Exit");
    gtk_signal_connect_object(GTK_OBJECT(Button),"clicked",
				GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(window));
	gtk_signal_connect_object(GTK_OBJECT(Button), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(window));
	gtk_widget_show(Button);
	gtk_box_pack_start(GTK_BOX(VBox),Button,FALSE,FALSE,0);
/*************************************** Sizes **********************************************/
	Tmp=gtk_hseparator_new();
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(VBox),Tmp,FALSE,FALSE,5);

	Box=gtk_hbox_new(FALSE,0);
	Tmp=gtk_label_new("X:  ");
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,0);

	XSize=gtk_adjustment_new(24,1,Max,1,Max/50,0);
	Tmp=gtk_spin_button_new(GTK_ADJUSTMENT(XSize),1,0);
	gtk_widget_show(Tmp);
	gtk_widget_show(Box);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,TRUE,TRUE,0);
//	gtk_box_pack_start(GTK_BOX(VBox),Box,FALSE,FALSE,0);

//	Box=gtk_hbox_new(FALSE,0);
	Tmp=gtk_label_new("  Y:  ");
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,0);

	YSize=gtk_adjustment_new(24,1,Max,1,Max/50,0);
	Tmp=gtk_spin_button_new(GTK_ADJUSTMENT(YSize),1,0);
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,TRUE,TRUE,0);

	Tmp=gtk_label_new("  W:  ");
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,0);

	Width=gtk_adjustment_new(1,0.1,10,.1,Max/50,0);
	Tmp=gtk_spin_button_new(GTK_ADJUSTMENT(Width),1,0);
	WidthBut=Tmp;
	gtk_signal_connect(GTK_OBJECT(Tmp),"changed",GTK_SIGNAL_FUNC(ProxyF),DrawArea);
	gtk_spin_button_set_digits(GTK_SPIN_BUTTON(Tmp),1);
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,TRUE,TRUE,0);

	gtk_widget_show(Box);
	gtk_box_pack_start(GTK_BOX(VBox),Box,FALSE,FALSE,0);

/*************************************** Options **********************************************/
	Tmp=gtk_hseparator_new();
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(VBox),Tmp,FALSE,FALSE,5);

	Tmp=gtk_check_button_new_with_label("Invert");
	gtk_signal_connect(GTK_OBJECT(Tmp),"toggled",GTK_SIGNAL_FUNC(InvertF),DrawArea);
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(VBox),Tmp,FALSE,FALSE,0);

	LnFlag=gtk_check_button_new_with_label("Logarithmic");
	gtk_signal_connect(GTK_OBJECT(LnFlag),"toggled",GTK_SIGNAL_FUNC(NormaliseF),DrawArea);
	gtk_widget_show(LnFlag);
	gtk_box_pack_start(GTK_BOX(VBox),LnFlag,FALSE,FALSE,0);
/*************************************** Normalisation ****************************************/
/*	Tmp=gtk_hseparator_new();
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(VBox),Tmp,FALSE,FALSE,5);*/

	Box=gtk_hbox_new(FALSE,0);

	Tmp=gtk_option_menu_new();
	Enable4=Tmp;
	Menu=gtk_menu_new();
	NMenu=GTK_MENU(Menu);
	MenuItem=gtk_menu_item_new_with_label("No Normalisation     ");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(Disable01F),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(NormaliseF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(WidthF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	MenuItem=gtk_menu_item_new_with_label("Normalise by Lines   ");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(Enable01F),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(NormaliseF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(WidthF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	MenuItem=gtk_menu_item_new_with_label("Normalise by Columns ");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(Enable01F),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(NormaliseF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(WidthF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	MenuItem=gtk_menu_item_new_with_label("Normalise by Matrix  ");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(Enable01F),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(NormaliseF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(WidthF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	gtk_widget_show(Menu);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(Tmp),Menu);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,0);
	gtk_widget_show(Tmp);

	Tmp=gtk_option_menu_new();
	Enable3=Tmp;
	Menu=gtk_menu_new();
	Norm01=GTK_MENU(Menu);
	MenuItem=gtk_menu_item_new_with_label("Distr ");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(NormaliseF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(WidthF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	MenuItem=gtk_menu_item_new_with_label("[-1,1]");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(NormaliseF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(WidthF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	gtk_widget_show(Menu);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(Tmp),Menu);
	gtk_widget_set_sensitive(Tmp,FALSE);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,5);
	gtk_widget_show(Tmp);

	gtk_widget_show(Box);
	gtk_box_pack_start(GTK_BOX(VBox),Box,FALSE,FALSE,10);
/*************************************** SubWindows ****************************************/
	Tmp=gtk_hseparator_new();
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(VBox),Tmp,FALSE,FALSE,5);

	Box=gtk_hbox_new(FALSE,0);
	Tmp=gtk_label_new("Show:");
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,5);

	Show=gtk_adjustment_new(0,0,Max,1,Max/50,0);
	Tmp=gtk_spin_button_new(GTK_ADJUSTMENT(Show),1,0);
	gtk_signal_connect(GTK_OBJECT(Tmp),"changed",GTK_SIGNAL_FUNC(DrawSF),DrawArea);
	gtk_widget_set_sensitive(Tmp,FALSE);
	Enable1=Tmp;
	gtk_widget_show(Tmp);
	gtk_widget_show(Box);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,5);

	Tmp=gtk_option_menu_new();
	Menu=gtk_menu_new();
	ShowLC=GTK_MENU(Menu);
	MenuItem=gtk_menu_item_new_with_label("Lines  ");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(AdjF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(DrawSF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	MenuItem=gtk_menu_item_new_with_label("Column ");
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(AdjF),DrawArea);
	gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",GTK_SIGNAL_FUNC(DrawSF),DrawArea);
	gtk_menu_append(GTK_MENU(Menu),MenuItem);
	gtk_widget_show(MenuItem);
	gtk_widget_show(Menu);
	gtk_option_menu_set_menu(GTK_OPTION_MENU(Tmp),Menu);
	gtk_box_pack_start(GTK_BOX(Box),Tmp,FALSE,FALSE,5);
	gtk_widget_show(Tmp);

	gtk_box_pack_start(GTK_BOX(VBox),Box,FALSE,FALSE,10);
/**********************************************************************************/
	Tmp=gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(Tmp),50,20);
	gtk_signal_connect(GTK_OBJECT(Tmp),"expose_event",GTK_SIGNAL_FUNC(DrawLogo),Tmp);
	gtk_widget_show(Tmp);
	gtk_box_pack_start(GTK_BOX(VBox),Tmp,TRUE,TRUE,0);

	gtk_widget_show(VBox);
	gtk_box_pack_start(GTK_BOX(HBox),VBox,FALSE,FALSE,5);
	gtk_widget_show(HBox);
	gtk_container_add(GTK_CONTAINER(window),HBox);

/****************************** Color Managment **********************************/
	unsigned i;
	gboolean *success=(gboolean*)malloc(256*sizeof(gboolean));
	if (!success)
	{
		gtk_widget_destroy(window);
		PrintError("Can't Allocate Memory!",0);
		exit(1);
	}

	gc=gdk_gc_new(DrawArea->window);
	ColorMap=gdk_colormap_get_system();

	Colors=(GdkColor*)malloc(256*sizeof(GdkColor));
	if (!Colors)
	{
		gtk_widget_destroy(window);
		PrintError("Can't Allocate Memory!",0);
		free(success);
		exit(1);
	}

	for (i=0;i<256;i++)
	{
		Colors[i].blue=0;
		Colors[i].red=256*i;
		Colors[i].green=65535-256*i;
	}

	gdk_colormap_alloc_colors(ColorMap,Colors,256,FALSE,FALSE,success);
	for (i=0;i<256;i++)
		if (success[i]==FALSE)
		{
			gtk_widget_destroy(window);
			PrintError("Can't Allocate Colors!",0);
			free(Colors);
			free(success);
			exit(1);
		}

	LColor=(GdkColor*)malloc(1*sizeof(GdkColor));
	if (!LColor)
	{
		gtk_widget_destroy(window);
		PrintError("Can't Allocate Memory!",0);
		gdk_colormap_free_colors(ColorMap,Colors,256);
		free(success);
		free(Colors);
		exit(1);
	}

	LColor[0].blue=65535;
	LColor[0].red=0;
	LColor[0].green=0;
	gdk_colormap_alloc_colors(ColorMap,LColor,1,FALSE,FALSE,success);

	if (success[0]==FALSE)
	{
		gtk_widget_destroy(window);
		PrintError("Can't allocate color!",0);
		gdk_colormap_free_colors(ColorMap,Colors,256);
		free(Colors);
		free(LColor);
		free(success);
		exit(1);
	}

	Font=gdk_font_load("fixed");
	if (!Font)
	{
		gtk_widget_destroy(window);
		PrintError("Can't load System Font!",0);
		gdk_colormap_free_colors(ColorMap,Colors,256);
		gdk_colormap_free_colors(ColorMap,LColor,1);
		free(Colors);
		free(LColor);
		free(success);
		exit(1);
	}
	LFont=gdk_font_load("*-helvetica-bold-o-*-*-*-100-*-*");
	if (!Font) LFont=gdk_font_load("fixed");

	gtk_main ();

	gdk_font_unref(Font);
	gdk_font_unref(LFont);
	gdk_colormap_free_colors(ColorMap,Colors,256);
	gdk_colormap_free_colors(ColorMap,LColor,1);
	free(Colors);
	free(LColor);
	free(success);
	return(0);
}

