#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "dsgwidgets.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"

static char *cfgfile=NULL;
static GtkWidget *window1;

int ChangeStr(char **src, const char *dest)
{
    if (*src) free(*src);
    *src=(char*)malloc((strlen(dest)+1)*sizeof(char));
    if (!(*src)) return 1;
    strcpy((*src),dest);
    return 0;
}

void
LoadFunc                               (GtkButton       *button,
                                        gpointer         user_data)
{
    FILE *f;
    unsigned long err;
    char *fn;
    fn=gds_select_file(_("Configuration File To Load"));
    if (fn)
    {
	f=fopen(fn,"r");
 	if (f)
	{
	    err=DoLoad(f);
	    if (err)
	    {
		gds_print_message(_("Error Loading Configuration File"));
		_Update();
	    }
	    else
	    {
		_NewValues();	    
		ChangeStr(&cfgfile,fn);
	    }
	    fclose(f);
/*	    gtk_widget_destroy(gtk_widget_get_toplevel(Widget));
	    MkWindow(Widget,GMI(ModIn));*/
	}
	else
	    gds_print_message(_("Can't Open Configuration File"));
	free(fn);
    }
}


void
SaveFunc                               (GtkButton       *button,
                                        gpointer         user_data)
{
    SaveAsFunc(NULL,user_data);
}


void
SaveAsFunc                             (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned char ExitFlag=0;
    FILE *f;
    char *stmp;
    if (button)
	stmp=gds_select_file(_("Save To The File"));
    else
    { 
	if (!cfgfile) ChangeStr(&cfgfile,"b.in");
    	stmp=cfgfile;
    }

    if (stmp)
    {
	if (button)
	{
    	    FILE *f=fopen(stmp,"r");
	    if (f)
	    {
		if (!gds_are_you_sure(_("File Alredy Exist! Overwrite?")))    
	    	    ExitFlag=1;
		fclose(f);
	    }
	}
	if (!ExitFlag)
	{
	    f=fopen(stmp,"w");
	    if (f)
	    {
		_Update();
		DoSave(f);
		fclose(f);
		if (button) ChangeStr(&cfgfile,stmp);
	    }
	    else
	        gds_print_message(_("Can't Open Configuration File For Writing"));
	}
	if (button) free(stmp);    
    }
}


void
ExecuteFunc                            (GtkButton       *button,
                                        gpointer         user_data)
{
    int err;
    extern int errno;
    char stmp[40];
    char *stmp2=NULL;
    pid_t child;
    
	// Updating configuration
    if (cfgfile) ChangeStr(&stmp2,cfgfile);
    ChangeStr(&cfgfile,"b.in");
    SaveAsFunc(NULL,user_data);
    if (stmp2) 
    {
	ChangeStr(&cfgfile,stmp2);
	free(stmp2);
    }
    
    child=fork();
    if (child<0)
	gds_print_message(_("Cant't fork new process"));
    else if (child)
    {
	gtk_widget_hide(window1);
	gtk_main_iteration();
	wait(&err);
	sprintf(stmp,"%s%i",_("Gene return's error code: "),err);
	gds_print_message(stmp);
	gtk_widget_show(window1);
    }
    else
    {
	execlp("gene",NULL);	
	_exit(errno);
    }
}


void
ResultsFunc                            (GtkButton       *button,
                                        gpointer         user_data)
{
    int err;
    extern int errno;
    
    pid_t child=fork();
    if (child<0)
	gds_print_message(_("Cant't fork new process"));
    else if (child)
    {
	gtk_widget_hide(window1);
	gtk_main_iteration();
	wait(&err);
	gtk_widget_show(window1);
    }
    else
    {
	execlp("pmd",NULL);	/* gtk_init(NULL,NULL) - OK
				gtk_init(argc,argv) - Exits */
	_exit(errno);
    }
}


void
APFunc                                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *window2 = create_window2 ();
  gtk_widget_show (window2);
}


static  GtkWidget *spinbutton10;
static  GtkWidget *spinbutton11;
static  GtkWidget *spinbutton12;
static  GtkWidget *spinbutton13;
static  GtkWidget *spinbutton14;
static  GtkWidget *spinbutton15;
static  GtkWidget *spinbutton16;
static  GtkWidget *optionmenu5_menu;
static  GtkWidget *optionmenu6_menu;
static  GtkWidget *optionmenu7_menu;
static  GtkWidget *optionmenu8_menu;
static  GtkWidget *optionmenu9_menu;
static  GtkWidget *optionmenu10_menu;
static  GtkWidget *optionmenu11_menu;
static  GtkWidget *optionmenu12_menu;
static  GtkWidget *optionmenu13_menu;
static  GtkWidget *entry1;
static  GtkWidget *entry2;
static  GtkWidget *entry3;
static  GtkWidget *entry4;
static  GtkWidget *button20;
static  GtkWidget *button21;


static unsigned long _nall;
static unsigned long _ncl;
static unsigned long _m;
static unsigned long _l;
static unsigned long _niter;
static unsigned long _kcl;
static char _ranf[20];
static unsigned long _ishif;
static char _qualit[20];
static char _ku[20];
static char _jmode[40];
static unsigned char _debug;
static char _stat[20];
static char _start[20];
static char _mixup[20];
static char _normal[20];
static char *_ffile1=NULL;
static char *_ffile2=NULL;
static char *_logfile=NULL;
static char *_bestfile=NULL;


void _Update()
{
    char *stmp;
    
    _nall=(unsigned long)gtk_spin_button_get_adjustment
	    (GTK_SPIN_BUTTON(spinbutton10))->value;
    _ncl=(unsigned long)gtk_spin_button_get_adjustment
	    (GTK_SPIN_BUTTON(spinbutton11))->value;
    _m=(unsigned long)gtk_spin_button_get_adjustment
	    (GTK_SPIN_BUTTON(spinbutton12))->value;
    _l=(unsigned long)gtk_spin_button_get_adjustment
	    (GTK_SPIN_BUTTON(spinbutton13))->value;
    _niter=(unsigned long)gtk_spin_button_get_adjustment
	    (GTK_SPIN_BUTTON(spinbutton14))->value;
    _kcl=(unsigned long)gtk_spin_button_get_adjustment
	    (GTK_SPIN_BUTTON(spinbutton15))->value;
    _ishif=(unsigned long)gtk_spin_button_get_adjustment
	    (GTK_SPIN_BUTTON(spinbutton16))->value;

    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu5_menu)->child),&stmp);
    strcpy(_ranf,stmp);
    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu6_menu)->child),&stmp);
    strcpy(_qualit,stmp);
    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu7_menu)->child),&stmp);
    strcpy(_ku,stmp);
    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu8_menu)->child),&stmp);
    strcpy(_jmode,stmp);
    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu10_menu)->child),&stmp);
    strcpy(_stat,stmp);
    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu11_menu)->child),&stmp);
    strcpy(_normal,stmp);
    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu12_menu)->child),&stmp);
    strcpy(_start,stmp);
    gtk_label_get(GTK_LABEL(GTK_BIN(optionmenu13_menu)->child),&stmp);
    strcpy(_mixup,stmp);
    _debug=g_list_index((GTK_MENU_SHELL(optionmenu9_menu))->children,
		    gtk_menu_get_active(GTK_MENU(optionmenu9_menu)));

    ChangeStr(&_ffile1, gtk_entry_get_text(GTK_ENTRY(entry1)));
    ChangeStr(&_ffile2, gtk_entry_get_text(GTK_ENTRY(entry2)));
    ChangeStr(&_logfile, gtk_entry_get_text(GTK_ENTRY(entry3)));
    ChangeStr(&_bestfile, gtk_entry_get_text(GTK_ENTRY(entry4)));
}

int FindCurrent(GList *mtmp, char *str)
{
    unsigned long i=0,Save=-1;
    char *stmp;
    GtkWidget *ltmp;

    do {
	ltmp=GTK_BIN(mtmp->data)->child;
	if (ltmp)
	{
	    gtk_label_get(GTK_LABEL(ltmp),&stmp);
	    if (!strcoll(stmp,str))
		return i;
	}
	else
	    Save=i;
	mtmp=mtmp->next;
	i++;
    } while (mtmp!=NULL);
    return Save;
}

void _NewValues()
{
    GList *mtmp;
    
    GtkAdjustment *Adj;
    Adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinbutton10));
    gtk_adjustment_set_value(Adj,_nall);
    gtk_spin_button_update(GTK_SPIN_BUTTON(spinbutton10));
    Adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinbutton11));
    gtk_adjustment_set_value(Adj,_ncl);
    gtk_spin_button_update(GTK_SPIN_BUTTON(spinbutton11));
    Adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinbutton12));
    gtk_adjustment_set_value(Adj,_m);
    gtk_spin_button_update(GTK_SPIN_BUTTON(spinbutton12));
    Adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinbutton13));
    gtk_adjustment_set_value(Adj,_l);
    gtk_spin_button_update(GTK_SPIN_BUTTON(spinbutton13));
    Adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinbutton14));
    gtk_adjustment_set_value(Adj,_niter);
    gtk_spin_button_update(GTK_SPIN_BUTTON(spinbutton14));
    Adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinbutton15));
    gtk_adjustment_set_value(Adj,_kcl);
    gtk_spin_button_update(GTK_SPIN_BUTTON(spinbutton15));
    Adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spinbutton16));
    gtk_adjustment_set_value(Adj,_ishif);
    gtk_spin_button_update(GTK_SPIN_BUTTON(spinbutton16));

    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu5_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu5_menu),
	    FindCurrent(mtmp,_ranf));
    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu6_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu6_menu),
	    FindCurrent(mtmp,_qualit));
    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu7_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu7_menu),
	    FindCurrent(mtmp,_ku));
    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu8_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu8_menu),
	    FindCurrent(mtmp,_jmode));
    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu10_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu10_menu),
	    FindCurrent(mtmp,_stat));
    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu11_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu11_menu),
	    FindCurrent(mtmp,_normal));
    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu12_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu12_menu),
	    FindCurrent(mtmp,_start));
    mtmp=GTK_MENU_SHELL(gtk_option_menu_get_menu
	(GTK_OPTION_MENU(optionmenu13_menu)))->children;
    gtk_option_menu_set_history(GTK_OPTION_MENU(optionmenu13_menu),
	    FindCurrent(mtmp,_mixup));

    gtk_option_menu_set_history(GTK_OPTION_MENU(gtk_menu_get_attach_widget(
	    GTK_MENU(optionmenu9_menu))),_debug);

    gtk_entry_set_text(GTK_ENTRY(entry1),_ffile1);
    gtk_entry_set_text(GTK_ENTRY(entry2),_ffile2);
    gtk_entry_set_text(GTK_ENTRY(entry3),_logfile);
    gtk_entry_set_text(GTK_ENTRY(entry4),_bestfile);

    if (strcoll(_ranf,_("ffile"))==0) /* ffile */
	    RanfFunc(NULL,1);
    else
	    RanfFunc(NULL,0);
}

void DoSave(FILE *f)
{
    fputs(_("# Number of Genes\n"),f);
    fprintf(f,"%lu\n",_nall);
    fputs(_("# Cluster Size\n"),f);
    fprintf(f,"%lu\n",_ncl);
    fputs(_("# Number of Slides\n"),f);
    fprintf(f,"%lu\n",_m);
    fputs(_("# Number of Tissues\n"),f);
    fprintf(f,"%lu\n",_l);
    fputs(_("# Number of Iterations\n"),f);
    fprintf(f,"%lu\n",_niter);
    fputs(_("# Number of Kernels\n"),f);
    fprintf(f,"%lu\n",_kcl);
    fputs(_("# Random Generator\n"),f);
    fprintf(f,"%s\n",_ranf);
    fputs(_("# RG \"ffile\" mode, file #1\n"),f);
    if (_ffile1) fprintf(f,"%s\n",_ffile1);
    else fputs(_("n.sym.txt"),f);		// Never can reach here, I hope
    fputs(_("# RG \"ffile\" mode, file #2\n"),f);
    if (_ffile1) fprintf(f,"%s\n",_ffile2);
    else fputs(_("p.sym.txt"),f);		// Never can reach here, I hope
    fputs(_("# Shift Of Random Generator\n"),f);
    fprintf(f,"%lu\n",_ishif);
    fputs(_("# Search Mode\n"),f);
    fprintf(f,"%s\n",_qualit);
    fputs(_("# Bayes Quality Mode\n"),f);
    fprintf(f,"%s\n",_ku);
    fputs(_("# Job Mode\n"),f);
    fprintf(f,"%s\n",_jmode);
    fputs(_("# Statistic\n"),f);
    fprintf(f,"%s\n",_stat);
    fputs(_("# Start\n"),f);
    fprintf(f,"%s\n",_start);
    fputs(_("# MixUp\n"),f);
    fprintf(f,"%s\n",_mixup);
    fputs(_("# Normalisation\n"),f);
    fprintf(f,"%s\n",_normal);
    fputs(_("# Log file name\n"),f);
    if (_logfile) fprintf(f,"%s\n",_logfile);
    else fputs(_("bbb.out"),f);		// Never can reach here, I hope
    fputs(_("# Output file name ( with seleceted cluster )\n"),f);
    if (_bestfile) fprintf(f,"%s\n",_bestfile);
    else fputs(_("best.txt"),f);	// Never can reach here, I hope
    fputs(_("# Debug Level\n"),f);
    fprintf(f,"%u\n",_debug);
}

// Skiping comments in configuration file
int SkipComments(FILE *f, int flag)
{
    int ch='#';
    char s[512];

    while ((ch=='#')&&(!feof(f)))
    {
	if (flag) fgets(s,120,f);
	ch=getc(f);
	flag=1;
    }
    if (feof(f)) return 1;
    fseek(f,-1,SEEK_CUR);
    return 0;
}

unsigned long DoLoad(FILE *f)
{
    unsigned utmp;
    char stmp[1024];
    if (SkipComments(f,0)) return 1;
    if (fscanf(f,"%lu",&_nall)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%lu",&_ncl)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%lu",&_m)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%lu",&_l)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%lu",&_niter)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%lu",&_kcl)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_ranf)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",stmp)!=1) return 1;
    ChangeStr(&_ffile1,stmp);
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",stmp)!=1) return 1;
    ChangeStr(&_ffile2,stmp);
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%lu",&_ishif)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_qualit)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_ku)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_jmode)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_stat)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_start)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_mixup)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",_normal)!=1) return 1;
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",stmp)!=1) return 1;
    ChangeStr(&_logfile,stmp);
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%s",stmp)!=1) return 1;
    ChangeStr(&_bestfile,stmp);
    if (SkipComments(f,1)) return 1;
    if (fscanf(f,"%u",&utmp)!=1) return 1;
    _debug=utmp;
    return 0;
}

void SendItems1(GtkWidget *a0, GtkWidget *a1, GtkWidget *a2,GtkWidget *a3,
    GtkWidget *a4, GtkWidget *a5, GtkWidget *a6, GtkWidget *b1, GtkWidget *b2,
    GtkWidget *b3, GtkWidget *b4, GtkWidget *b5, GtkWidget *b6, GtkWidget *b7, 
    GtkWidget *b8, GtkWidget *b9, GtkWidget *c1, GtkWidget *c2, GtkWidget *c3, 
    GtkWidget *c4, GtkWidget *d1,GtkWidget *d2, GtkWidget *w)
{
    spinbutton10=a0;
    spinbutton11=a1;
    spinbutton12=a2;
    spinbutton13=a3;
    spinbutton14=a4;
    spinbutton15=a5;
    spinbutton16=a6;
    optionmenu5_menu=b1;
    optionmenu6_menu=b2;
    optionmenu7_menu=b3;
    optionmenu8_menu=b4;
    optionmenu9_menu=b5;
    optionmenu10_menu=b6;
    optionmenu11_menu=b7;
    optionmenu12_menu=b8;
    optionmenu13_menu=b9;
    entry1=c1;
    entry2=c2;
    entry3=c3;
    entry4=c4;
    button20=d1;
    button21=d2;
    window1=w;
}

void
BrowseFunc                             (GtkButton       *button,
                                        gpointer         user_data)
{
    char *stmp;
    stmp=gds_select_file(_("Select file"));
    if (stmp)
	gtk_entry_set_text(GTK_ENTRY(user_data),stmp);
}


void 
RanfFunc				(GtkWidget	*widget,
					 gpointer	user_data)
{
    gtk_widget_set_sensitive (button20, (int)user_data);
    gtk_widget_set_sensitive (button21, (int)user_data);
    gtk_widget_set_sensitive (entry1, (int)user_data);
    gtk_widget_set_sensitive (entry2, (int)user_data);
}

