#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "dsgwidgets.h"
#include "support.h"

gint delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data)
{
	gtk_main_quit();
	return(FALSE);
}

gint delete_event_reject(GtkWidget *widget, GdkEvent  *event, gchar *str)
{
	if (str) gds_print_message(str);
	return(TRUE);
}

gint gds_SaveFileName(GtkWidget *Widget, gchar **stmp)
{
	char *tmp=gtk_file_selection_get_filename(GTK_FILE_SELECTION(gtk_widget_get_toplevel(Widget)));
	*stmp=(char*)malloc(strlen(tmp)+1);
	strcpy(*stmp,tmp);
}


/* FileSelectionDialog, returns
	NULL - if cancel pressed
	or string with file name selected ( must been released ) */


gchar *_gds_select_file(gchar *message, gboolean isCancel)
{
    char *stmp=NULL;

    GtkWidget *FileSelection=gtk_file_selection_new(message);
    gtk_container_set_border_width(GTK_CONTAINER(FileSelection),10);
    gtk_window_set_modal(GTK_WINDOW(FileSelection),TRUE);
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
	"clicked", GTK_SIGNAL_FUNC(gds_SaveFileName), &stmp);
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
	"clicked", GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(FileSelection));
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
	"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(FileSelection));

    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->cancel_button),
	"clicked", GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(FileSelection));
    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->cancel_button),
	"clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(FileSelection));
    gtk_widget_set_sensitive(GTK_FILE_SELECTION(FileSelection)->cancel_button,isCancel);
    gtk_widget_show(FileSelection);

    gtk_main();
    return stmp;
}


void ISureF(GtkWidget *widget, unsigned char *Flag)
{
	*Flag=1;
}

gboolean gds_are_you_sure(gchar *Message)
{
	GtkWidget *Tmp;
	GtkWidget *Dialog;
	unsigned char ExitFlag=0;

	Dialog=gtk_dialog_new();
	gtk_signal_connect (GTK_OBJECT (Dialog), "delete_event",GTK_SIGNAL_FUNC (delete_event),NULL);
	gtk_window_set_modal(GTK_WINDOW(Dialog),TRUE);
	gtk_window_set_default_size(GTK_WINDOW(Dialog),350,200);
	gtk_window_set_title(GTK_WINDOW(Dialog),_("Are You Sure?"));
	gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(Dialog)->vbox),10);
	gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(Dialog)->vbox),10);

	Tmp=gtk_button_new_with_label(_("Yes"));
	gtk_signal_connect(GTK_OBJECT(Tmp),"clicked",GTK_SIGNAL_FUNC(ISureF),&ExitFlag);
	gtk_signal_connect_object(GTK_OBJECT(Tmp),"clicked",
				GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(Dialog));
	gtk_signal_connect_object(GTK_OBJECT(Tmp), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(Dialog));
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(Dialog)->action_area),Tmp);

	Tmp=gtk_button_new_with_label(_("No"));
	gtk_signal_connect_object(GTK_OBJECT(Tmp),"clicked",
				GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(Dialog));
	gtk_signal_connect_object(GTK_OBJECT(Tmp), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(Dialog));
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(Dialog)->action_area),Tmp);

	Tmp=gtk_label_new(Message);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog)->vbox),Tmp,TRUE,TRUE,0);
	gtk_widget_show_all(Dialog);
	gtk_main();
	return ExitFlag;
}

void gds_print_message(gchar *Message)
{
	GtkWidget *Tmp;
	GtkWidget *Dialog;

	Dialog=gtk_dialog_new();
	gtk_signal_connect (GTK_OBJECT (Dialog), "delete_event",GTK_SIGNAL_FUNC (delete_event),NULL);
	gtk_window_set_modal(GTK_WINDOW(Dialog),TRUE);
	gtk_window_set_default_size(GTK_WINDOW(Dialog),350,200);
	gtk_window_set_title(GTK_WINDOW(Dialog),_("Error Message"));
	gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(Dialog)->vbox),10);
	gtk_box_set_spacing(GTK_BOX(GTK_DIALOG(Dialog)->vbox),10);
	Tmp=gtk_button_new_with_label(_("OK"));
	gtk_signal_connect_object(GTK_OBJECT(Tmp),"clicked",
				GTK_SIGNAL_FUNC(delete_event),GTK_OBJECT(Dialog));
	gtk_signal_connect_object(GTK_OBJECT(Tmp), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(Dialog));
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(Dialog)->action_area),Tmp);

	Tmp=gtk_label_new(Message);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog)->vbox),Tmp,TRUE,TRUE,0);
	gtk_widget_show_all(Dialog);
	gtk_main();
}

void gds_mk_window_event(GtkWidget *Widget, GtkBox *Box)
{
    gds_mk_window(Box,NULL,0);
}

GtkWindow *gds_mk_window(GtkBox *Box, char *Name, gboolean ExitFlag)
{
    GtkWidget *Window;
    Window=gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_container_set_border_width(GTK_CONTAINER(Window),10);
    gtk_window_set_modal(GTK_WINDOW(Window),TRUE);
    gtk_window_set_default_size(GTK_WINDOW(Window),350,200);
    if (Name) gtk_window_set_title(GTK_WINDOW(Window),Name);
    if (ExitFlag)
	gtk_signal_connect (GTK_OBJECT(Window), "delete_event",
    		GTK_SIGNAL_FUNC (delete_event),NULL);
    gtk_container_add(GTK_CONTAINER(Window),GTK_WIDGET(Box));
    gtk_widget_show(Window);
    return GTK_WINDOW(Window);
}
