#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

#include "display.h"

#define clyport 13012
#define port 13011
char Server[16]="127.0.0.1";
#define ReAnnounceTimeout 3000
#define Timeout 600
#define BufferSize 1024

main(int argc, char *argv[])
{
    int err;
    int dsock;
    struct sockaddr_in servaddr, clientaddr;
    int clientaddrsize=sizeof(struct sockaddr_in);
    unsigned char idmsg[5];
    unsigned char buf[BufferSize];
    time_t LastPacketTime,LastAnnounceTime,CurTime;

    if (argc>2) {
    	printf("Usage: %s [server ip]\n",argv[0]);
    	exit(1);
    }
    if (argc==2) {
    	strncpy(Server,argv[1],15);
    }

    dsock=socket(PF_INET,SOCK_DGRAM,IPPROTO_UDP);
    if (dsock<0)
    {
	fprintf(stderr,"Can't open socket!");
	exit(1);
    }
    
	// Configuring server port ( Parsing configuration )
    servaddr.sin_family=AF_INET;
    servaddr.sin_port=htons(clyport);
    servaddr.sin_addr.s_addr=htonl(INADDR_ANY);
    
    if (bind(dsock,(struct sockaddr*)&servaddr,sizeof(struct sockaddr_in)))
    {
	fprintf(stderr, "Can't bind socket on port %lu\n",port);
	exit(1);
    }

	// Configuring server port ( Parsing configuration )
    servaddr.sin_family=AF_INET;
    servaddr.sin_port=htons(port);
    servaddr.sin_addr.s_addr=inet_addr(Server);

    idmsg[0]=0xD0;	// New client arrived message

    err=sendto(dsock,idmsg,1,0,(struct sockaddr*)&servaddr,
		sizeof(struct sockaddr_in));
    
    LastPacketTime=time(NULL);
    LastAnnounceTime=LastPacketTime;
    while (1)
    {
	err=recvfrom(dsock,(void*)buf,BufferSize,0,
    	    (struct sockaddr*)&clientaddr,&clientaddrsize);
	
	if ((err>0)&&(buf[0]==0xD1))
	{
	    LastPacketTime=time(NULL);
	    Display(buf+1);
	}
	CurTime=time(NULL);
	if ((CurTime-LastPacketTime>Timeout)||
	    (CurTime-LastAnnounceTime>ReAnnounceTimeout))
	{
	    err=sendto(dsock,idmsg,1,0,(struct sockaddr*)&servaddr,
		    sizeof(struct sockaddr_in));
	    LastAnnounceTime=CurTime;
	}
    }
}
