#include <time.h>
#include "display.h"

#define perline 6

void Display(char *buf) {
	struct tm date;
	time_t itm;
	char ct[32],fn[32];
	unsigned int ti;
	unsigned int Dti;
	unsigned int nd;
	
	unsigned int i, pos;
	
	itm=*(time_t*)buf;
	pos=sizeof(time_t); 		ti=*(unsigned int*)(buf+pos);
	pos+=sizeof(unsigned int); 	Dti=*(unsigned int*)(buf+pos);
	pos+=sizeof(unsigned int);	nd=*(unsigned int*)(buf+pos);
	
	pos+=sizeof(unsigned int);
	
	gmtime_r(&itm,&date);
//	sprintf(fn,"%04u%02u%02u",date.tm_year+1900,date.tm_mon+1,date.tm_mday);  
	sprintf(ct,"%02u:%02u:%02u  ",date.tm_hour,date.tm_min,date.tm_sec);

	printf("%s (%us data, %us dispersion)\n",ct,ti,Dti);
	
	for (i=0;i<nd;i++,pos+=sizeof(unsigned int)) {
		if (i%perline==0) {
			printf("\n\t");
		}
		printf("%6u  ", *(unsigned int*)(buf+pos)/ti);
	} 	
	printf("\n");
	for (i=0;i<nd;i++,pos+=sizeof(double)) {
		if (i%perline==0) {
			printf("\n\t");
		}
		printf("% 1.3lf  ", *(double*)(buf+pos));
	} 	
	printf("\n\n");
}
