/* Huge speed optimization posible:
	Replace corelation matrix on square of correlation matrix, it will
	remove need of cpu-consuming sqrt function
*/
#include <math.h>

int n;				/* Value position in flow */
unsigned int a[size];           /* Coincedence, Sum, ... */
unsigned int v[nd];		/* Value  for dispersion calculation */
double D[Dsize];		/* Dispersion */
unsigned int *S = a;		/* Pointer on Sum */
unsigned int *S2 = a + maxpow;	/* Pointer on Sums of second row */


void disp_init() {
	int i;
	
	n=0;
	for(i=0;i<nd*(nd+1)/2;i++) D[i]=0;
/*	for(i=0;i<nd;i++) {
		S[i]=0;
		v[i]=0;
	}*/
}


void disp_event() {
	int i,j,k;
	unsigned long t;
	
	n++;
	t=n*(n-1);
	
	for (i=0;i<nd;i++) {
/*		S[i]+=v[i];*/
		v[i]*=n;
		if (t) D[i]+=(double)(((S[i]-v[i])*(S[i]-v[i])))/t;
	}
	
	if (!t) return;
	
	for (i=0,k=nd;i<nd;i++) {
		for (j=i+1;j<nd;j++,k++) {
		    D[k]+=(double)(int)(((S[i]-v[i])*(S[j]-v[j])))/t;
		}
		v[i]=0;
	}
}

void disp_post() {
    int i,j,k;

    if (n>1) {
	for (i=0;i<nd;i++) {
	    D[i]/=(n-1);
	    D[i]=sqrt(D[i]);
	}
    
	for (i=0,k=nd;i<nd;i++) {
	    for (j=i+1;j<nd;j++,k++) {
		D[k]/=((n-1)*D[i]*D[j]);
	    }
	}
    }
}
